/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;
import java.util.List;

public abstract class AppWindowEvent
extends IPCEvent {
    public EventType type;

    public AppWindowEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        FILE_NEWED,
        FILE_OPENED,
        FILE_SAVED,
        FILE_SAVE_DONE,
        FILE_SAVE_TO_BYTES_DONE,
        APP_EXIT,
        LOCKED_INTERFACE_INVOKED;

    }

    public static class LockedInterfaceInvoked
    extends AppWindowEvent {
        public String lockMsg;
        public String lockID;
        public String branch1;
        public String branch2;

        public LockedInterfaceInvoked(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.LOCKED_INTERFACE_INVOKED;
            this.lockMsg = (String)ltv.getEventParameters().get(0);
            this.lockID = (String)ltv.getEventParameters().get(1);
            this.branch1 = (String)ltv.getEventParameters().get(2);
            this.branch2 = (String)ltv.getEventParameters().get(3);
        }

        public String toString() {
            return super.toString() + "\n\tlockMsg = " + this.lockMsg + "\n\tlockID = " + this.lockID + "\n\tbranch1 = " + this.branch1 + "\n\tbranch2 = " + this.branch2;
        }
    }

    public static class AppExit
    extends AppWindowEvent {
        public AppExit(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.APP_EXIT;
        }

        public String toString() {
            return super.toString();
        }
    }

    public static class FileSaveToBytesDone
    extends AppWindowEvent {
        public List<Byte> data;

        public FileSaveToBytesDone(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_SAVE_TO_BYTES_DONE;
            this.data = (List)ltv.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tdata = " + this.data;
        }
    }

    public static class FileSaveDone
    extends AppWindowEvent {
        public Boolean success;

        public FileSaveDone(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_SAVE_DONE;
            this.success = (Boolean)ltv.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tsuccess = " + this.success;
        }
    }

    public static class FileSaved
    extends AppWindowEvent {
        public FileSaved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_SAVED;
        }

        public String toString() {
            return super.toString();
        }
    }

    public static class FileOpened
    extends AppWindowEvent {
        public FileOpened(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_OPENED;
        }

        public String toString() {
            return super.toString();
        }
    }

    public static class FileNewed
    extends AppWindowEvent {
        public FileNewed(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.FILE_NEWED;
        }

        public String toString() {
            return super.toString();
        }
    }
}

